package gov.va.med.mhv.usermgmt.bizobj;

import gov.va.med.mhv.usermgmt.enumeration.AuthenticationDefermentReason;
import gov.va.med.mhv.usermgmt.enumeration.AuthenticationStatus;
import gov.va.med.mhv.usermgmt.transfer.InPersonAuthentication;


/**
 * Business object for the InPersonAuthentication application entity
 *
 * Generated Skeleton Code
 */
 
public class InPersonAuthenticationBO extends InPersonAuthenticationBaseBO {

	public InPersonAuthentication saveAndUpdateStatus(InPersonAuthentication ipa, AuthenticationStatus newStatus) {
		AuthenticationStatus oldStatus = getStatus() == null ? AuthenticationStatus.getEnum(AuthenticationStatus.UNAUTHENTICATED) : getStatus();
		setInPersonAuthenticationValues(ipa);
		// Preserve old values for return in case of error
		InPersonAuthentication oldValues = getInPersonAuthenticationValues();
		setStatus(newStatus);
		validate();
		if (!getAllMessages().hasErrorMessages()) {
			doStatusChecks(oldValues, oldStatus);
			if (!getAllMessages().hasErrorMessages()) {
				save();	
				return getInPersonAuthenticationValues();
			}
		}
		
		oldValues.getMessages().addMessages(getAllMessages());
		return oldValues;
	}

	private void doStatusChecks(InPersonAuthentication oldValues, AuthenticationStatus oldStatus) {
		boolean form = getParticipationFormSigned() == null ? false : getParticipationFormSigned().booleanValue();
		boolean id = getIdentificationPresented() == null ? false : getIdentificationPresented().booleanValue();
		boolean eAccess = getApprovedForRecordsAccess() == null ? false : getApprovedForRecordsAccess();
		
		boolean oldForm = oldValues.getParticipationFormSigned() == null ? false : oldValues.getParticipationFormSigned().booleanValue();
		boolean oldId = oldValues.getIdentificationPresented() == null ? false : oldValues.getIdentificationPresented().booleanValue();
		
		
		// In process/prereq complete
		if (AuthenticationStatus.INPROCESS.equals(getStatus().getName()) || AuthenticationStatus.PREREQUISITESCOMPLETE.equals(getStatus().getName())) {
//JAZZ: Task#20523 - Show video check box removal from IPA Authentication Page.	
//			if(!video && !id && !form && (oldVideo || oldForm || oldId)){
//				addError("deselect.prereqs", new String [] {"videoViewed", "participationFormSigned", "identificationPresented"}, null);
//			}
//			else if (!video && !form && !id) {
//				addError("one.prereq.required", new String [] {"videoViewed", "participationFormSigned", "identificationPresented"}, null);
//			}
			
			if (eAccess) {
				addError("records.access.not.allowed", new String [] {"approvedForRecordsAccess"}, null);
			}
			
			if (getAuthenticatingFacility() == null) {
				addError( "null.not.allowed", new String [] {"authenticatingFacility"}, new Object[] { "Authenticating Facility" } );
			}
			
			if (getDefermentReason() == null) {
				addError("deferral.reason.missing", new String [] {"defermentReason"}, null);
			}
			
			
		}
		
		if((AuthenticationStatus.UNAUTHENTICATED.equals(getStatus().getName()) || AuthenticationStatus.INPROCESS.equals(getStatus().getName()) || AuthenticationStatus.PREREQUISITESCOMPLETE.equals(getStatus().getName())) 
				&& form && id && getDefermentReason() != null && 
				AuthenticationDefermentReason.getEnum(AuthenticationDefermentReason.PREREQUISITESINCOMPLETE).equals(getDefermentReason())){
			addError("invalid.defer.reason", new String [] {"defermentReason"}, null);
		}
		
		// Pending Authentication/authenticated
		if (AuthenticationStatus.PENDINGAUTHENTICATION.equals(getStatus().getName()) || AuthenticationStatus.AUTHENTICATED.equals(getStatus().getName())) {
			if (!form || !id || !eAccess) {
				addError("all.prereqs.required", new String [] {"videoViewed", "participationFormSigned", "identificationPresented", "approvedForRecordsAccess"}, new Object [] {});
			}
			
			if (getAuthenticatingFacility() == null) {
				addError( "null.not.allowed", new String [] {"authenticatingFacility"}, new Object[] { "Authenticating Facility" } );
			}
			
			if (getAuthenticationDate() == null) {
				addError( "null.not.allowed", new String [] {"authenticationDate"}, new Object[] { "Authentication Date" } );
			}
		}
		
		// Pending unauthentication
		if (AuthenticationStatus.PENDINGREMOVAL.equals(getStatus().getName())) {
			if (getRemovalReason() == null) {
				addError("removal.reason.missing", new String [] {"removalReason"}, new Object [] {} );
			}
		}

	}

}